<?php
if($_SERVER["SCRIPT_NAME"] != "/index.php"){ header("HTTP/1.0 403 Forbidden");echo base64_decode("PCFET0NUWVBFIEhUTUwgUFVCTElDICItLy9JRVRGLy9EVEQgSFRNTCAyLjAvL0VOIj4KPGh0bWw+PGhlYWQ+Cjx0aXRsZT40MDMgRm9yYmlkZGVuPC90aXRsZT4KPC9oZWFkPjxib2R5Pgo8aDE+Rm9yYmlkZGVuPC9oMT4KPHA+WW91IGRvbid0IGhhdmUgcGVybWlzc2lvbiB0byBhY2Nlc3MgdGhpcyByZXNvdXJjZS48L3A+Cjxocj4KPC9ib2R5PjwvaHRtbD4=");die(); }
?>
<?php
/**
 * The helper class.
 */

/**
 * Wrapper class for helper functions.
 */
class MASHSB_RWMB_Helper
{
	/**
	 * Stores all registered fields
	 * @var array
	 */
	private static $fields = array();

	/**
	 * Hash all fields into an indexed array for search
	 * @param string $post_type Post type
	 */
	public static function hash_fields( $post_type )
	{
		self::$fields[$post_type] = array();

		$meta_boxes = MASHSB_RWMB_Core::get_meta_boxes();
		foreach ( $meta_boxes as $meta_box )
		{
			$meta_box = MASHSB_RW_Meta_Box::normalize( $meta_box );
			if ( ! in_array( $post_type, $meta_box['post_types'] ) )
			{
				continue;
			}
			foreach ( $meta_box['fields'] as $field )
			{
				if ( ! empty( $field['id'] ) )
				{
					self::$fields[$post_type][$field['id']] = $field;
				}
			}
		}
	}

	/**
	 * Find field by field ID.
	 * This function finds field in meta boxes registered by 'rwmb_meta_boxes' filter.
	 *
	 * @param string $field_id Field ID
	 * @param int    $post_id
	 * @return array|false Field params (array) if success. False otherwise.
	 */
	public static function find_field( $field_id, $post_id = null )
	{
		$post_type = get_post_type( $post_id );
		if ( empty( self::$fields[$post_type] ) )
		{
			self::hash_fields( $post_type );
		}
		$fields = self::$fields[$post_type];
		if ( ! isset( $fields[$field_id] ) )
		{
			return false;
		}
		$field = $fields[$field_id];
		return call_user_func( array( MASHSB_RW_Meta_Box::get_class_name( $field ), 'normalize' ), $field );
	}

	/**
	 * Get post meta
	 *
	 * @param string   $key     Meta key. Required.
	 * @param int|null $post_id Post ID. null for current post. Optional
	 * @param array    $args    Array of arguments. Optional.
	 *
	 * @return mixed
	 */
	public static function meta( $key, $args = array(), $post_id = null )
	{
		$post_id = empty( $post_id ) ? get_the_ID() : $post_id;
		$args    = wp_parse_args( $args, array(
			'type'     => 'text',
			'multiple' => false,
			'clone'    => false,
		) );
		// Always set 'multiple' true for following field types
		if ( in_array( $args['type'], array( 'checkbox_list', 'autocomplete', 'file', 'file_advanced', 'image', 'image_advanced', 'plupload_image', 'thickbox_image' ) ) )
		{
			$args['multiple'] = true;
		}

		$field = array(
			'id'       => $key,
			'type'     => $args['type'],
			'clone'    => $args['clone'],
			'multiple' => $args['multiple'],
		);
		$class = MASHSB_RW_Meta_Box::get_class_name( $field );

		switch ( $args['type'] )
		{
			case 'taxonomy_advanced':
				if ( empty( $args['taxonomy'] ) )
				{
					break;
				}
				$meta     = get_post_meta( $post_id, $key, ! $args['multiple'] );
				$term_ids = wp_parse_id_list( $meta );
				// Allow to pass more arguments to "get_terms"
				$func_args = wp_parse_args( array(
					'include'    => $term_ids,
					'hide_empty' => false,
				), $args );
				unset( $func_args['type'], $func_args['taxonomy'], $func_args['multiple'] );
				$meta = get_terms( $args['taxonomy'], $func_args );
				break;
			case 'taxonomy':
				$meta = empty( $args['taxonomy'] ) ? array() : get_the_terms( $post_id, $args['taxonomy'] );
				break;
			case 'map':
				$field = array(
					'id'       => $key,
					'multiple' => false,
					'clone'    => false,
				);
				$meta  = MASHSB_RWMB_Map_Field::the_value( $field, $args, $post_id );
				break;
			case 'oembed':
				$meta = MASHSB_RWMB_OEmbed_Field::the_value( $field, $args, $post_id );
				break;
			default:
				$meta = call_user_func( array( $class, 'get_value' ), $field, $args, $post_id );
				break;
		}
		return apply_filters( 'rwmb_meta', $meta, $key, $args, $post_id );
	}
}
